<?= $this->include('layout/header_admin') ?>

<h3 class="mb-4" style="color: white;">📅 Data Aktivitas Harian</h3>

<div class="row mb-3">
    <div class="col-md-8">
        <form method="get" class="row g-2">
            <div class="col-md-5">
                <input type="text" name="keyword" class="form-control"
                    placeholder="Cari aktivitas"
                    value="<?= $_GET['keyword'] ?? '' ?>">
            </div>

            <div class="col-md-4">
                <input type="date" name="tanggal" class="form-control"
                    value="<?= $_GET['tanggal'] ?? '' ?>">
            </div>

            <div class="col-md-3">
                <button class="btn btn-primary w-100">Cari</button>
            </div>
        </form>
    </div>

    <div class="col-md-4 text-end">
        <a href="/auth/aktivitas/create" class="btn btn-success">
            ➕ Tambah Aktivitas
        </a>
    </div>
</div>

<div class="table-responsive">
    <table class="table table-bordered table-striped align-middle">
        <thead class="table-dark">
            <tr>
                <th>Tanggal</th>
                <th>Jam</th>
                <th>Aktivitas</th>
                <th width="180">Media</th>
                <th width="150">Aksi</th>
            </tr>
        </thead>

        <tbody>
            <?php if (empty($aktivitas)): ?>
                <tr>
                    <td colspan="5" class="text-center text-muted">
                        Data aktivitas belum tersedia
                    </td>
                </tr>
            <?php endif ?>

            <?php foreach ($aktivitas as $a): ?>
                <tr>
                    <td><?= esc($a['tanggal']) ?></td>
                    <td><?= esc($a['jam']) ?></td>
                    <td><?= esc($a['nama_aktivitas']) ?></td>

                    <!-- MEDIA -->
                    <td class="text-center">
                        <?php if ($a['media_type'] === 'upload' && $a['media']): ?>

                            <?php
                            $ext = pathinfo($a['media'], PATHINFO_EXTENSION);
                            ?>

                            <?php if (in_array($ext, ['jpg', 'jpeg', 'png'])): ?>
                                <img src="/uploads/aktivitas/<?= esc($a['media']) ?>"
                                    class="img-thumbnail"
                                    width="90">
                            <?php else: ?>
                                <video width="120" controls>
                                    <source src="/uploads/aktivitas/<?= esc($a['media']) ?>">
                                </video>
                            <?php endif ?>

                        <?php elseif ($a['media_type'] === 'link' && $a['media']): ?>

                            <a href="<?= esc($a['media']) ?>" target="_blank"
                                class="btn btn-outline-primary btn-sm">
                                🔗 Lihat Video
                            </a>

                        <?php else: ?>
                            <span class="text-muted">-</span>
                        <?php endif ?>
                    </td>

                    <!-- AKSI -->
                    <td>
                        <a href="/auth/aktivitas/edit/<?= $a['id'] ?>"
                            class="btn btn-warning btn-sm">
                            Edit
                        </a>

                        <a href="/auth/aktivitas/delete/<?= $a['id'] ?>"
                            class="btn btn-danger btn-sm"
                            onclick="return confirm('Yakin hapus data?')">
                            Hapus
                        </a>
                    </td>
                </tr>
            <?php endforeach ?>
        </tbody>
    </table>
</div>

<div class="d-flex justify-content-center">
    <?= $pager->links() ?>
</div>

<?= $this->include('layout/footer_admin') ?>